//
//  SceneDelegate.swift
//  Do It
//
//  Created by Jim Dovey on 8/23/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import UIKit
import SwiftUI

// All scenes share this single lazily-initialized data center.
// Previews can create their own.
fileprivate let sharedDataCenter = DataCenter()

class SceneDelegate: UIResponder, UIWindowSceneDelegate {

    var window: UIWindow?

    func scene(_ scene: UIScene, willConnectTo session: UISceneSession, options connectionOptions: UIScene.ConnectionOptions) {
        // Use this method to optionally configure and attach the UIWindow `window` to the provided UIWindowScene `scene`.
        // If using a storyboard, the `window` property will automatically be initialized and attached to the scene.
        // This delegate does not imply the connecting scene or session are new (see `application:configurationForConnectingSceneSession` instead).
        
        // ensure data center etc. are preflighted
        _ = sharedDataCenter
        presentView(Home(), in: scene)
    }
    
    private func presentView<Content: View>(_ view: Content, in scene: UIScene) {
        // Use a UIHostingController as window root view controller.
        if let windowScene = scene as? UIWindowScene {
            let rootView = view
                .environmentObject(sharedDataCenter)
                .modifier(AssignUndoManager(data: sharedDataCenter))
                .publishingErrors()
            let window = UIWindow(windowScene: windowScene)
            window.rootViewController = UIHostingController(rootView: rootView)
            self.window = window
            window.makeKeyAndVisible()
        }
    }
    
    private struct AssignUndoManager: ViewModifier {
        var data: DataCenter
        @Environment(\.undoManager) var undoManager
        func body(content: Content) -> some View {
            content.onAppear(perform: self.data.undoManager == nil
                ? { self.data.undoManager = self.undoManager }
                : nil)
        }
    }
}

